<?php
require_once '../layout/_top.php';
require_once '../helper/connection.php';

// Check if the user has the 'admin' role
if ($_SESSION['login']['role'] !== 'admin') {
    $_SESSION['info'] = [
      'status' => 'failed',
      'message' => 'Unauthorized access: Insufficient privileges'
    ];
    header('Location: ./index.php');
    exit(); // Stop further execution
  }
?>

<section class="section">
  <div class="section-header d-flex justify-content-between">
    <h1>Tambah Kartu</h1>
    <a href="./index.php" class="btn btn-light">Kembali</a>
  </div>
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-body">
          <!-- // Form -->
          <form action="./store.php" method="POST">
            <table cellpadding="8" class="w-100">      

<?php
// Mendapatkan nilai terakhir dari idcard
$result = mysqli_query($connection, "SELECT CAST(SUBSTRING(idcard, 5) AS SIGNED) as id_number FROM guest WHERE idcard LIKE 'VIP-%'");
$id_numbers = array();

// Mengambil semua nomor ID yang sudah ada
while ($row = mysqli_fetch_assoc($result)) {
    $id_numbers[] = $row['id_number'];
}

// Mencari ID yang belum digunakan
$missing_id = findMissingID($id_numbers);

// Membuat idcard baru dengan menambahkan 1 ke nilai terakhir atau menggunakan ID yang belum digunakan
$new_id = $missing_id !== null ? $missing_id : max($id_numbers) + 1;
?>

<!-- Menampilkan form dengan nilai default dari ID Kartu terakhir atau ID yang belum digunakan -->
<tr>
    <td>ID Kartu</td>
    <td><input class="form-control" type="text" name="idcard" size="20" value="VIP-<?php echo $new_id; ?>" required readonly></td>
</tr>

<?php

// Fungsi untuk mencari ID yang belum digunakan
function findMissingID($id_numbers)
{
    $all_ids = range(min($id_numbers), max($id_numbers));

    // Menggunakan fungsi array_diff untuk menemukan ID yang belum digunakan
    $missing_ids = array_diff($all_ids, $id_numbers);

    // Mengembalikan ID yang belum digunakan pertama kali
    return !empty($missing_ids) ? reset($missing_ids) : null;
}
?>
              
              <tr>
                <td>Nama Tamu</td>
                <td><input class="form-control" type="text" name="nama" size="20" required></td>
              </tr>

              <tr>
                <td>No. Kamar</td>
                <td><input class="form-control" type="number" name="room" size="20" required></td>
              </tr>

              <tr>
                <td>Jenis Kelamin</td>
                <td>
                  <select class="form-control" name="jenkel" id="jenkel" required>
                    <option value="">--Pilih Jenis Kelamin--</option>
                    <option value="Laki-laki">Laki-laki</option>
                    <option value="Perempuan">Perempuan</option>
                  </select>
                </td>
              </tr>

              <tr>
                <td>Pesan</td>
                <td><input class="form-control" type="text" name="pesan" placeholder="Contoh: Sugeng Rawuh" id="pesan" required></td>
              </tr>
              
              <tr>
                <td>
                  <input class="btn btn-primary" type="submit" name="proses" value="Simpan">
                  <input class="btn btn-danger" type="reset" name="batal" value="Bersihkan"></td>
              </tr>

            </table>
          </form>
        </div>
      </div>
    </div>
</section>

<?php
require_once '../layout/_bottom.php';
?>