<?php
require_once 'helper/connection.php';
session_start();

$errorMsg = ""; // Initialize an error message variable

// Check if the user has the 'admin' role
if ($_SESSION['login']['role'] !== 'admin') {
  $_SESSION['info'] = [
    'status' => 'failed',
    'message' => 'Unauthorized access: Insufficient privileges'
  ];
  header('Location: ../roleadmin/index.php');
  exit(); // Stop further execution
}

if (isset($_POST['submit'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $role = $_POST['role'];

    // Hash the password using SHA-256
    $hashedPassword = hash('sha256', $password);

    // Check if the username already exists
    $checkUsernameQuery = "SELECT * FROM login WHERE username='$username'";
    $checkResult = mysqli_query($connection, $checkUsernameQuery);

    if (mysqli_num_rows($checkResult) > 0) {
        $errorMsg = "Username already exists. Please choose a different username.";
    } else {
        // Insert the new user into the database
        $insertQuery = "INSERT INTO login (username, password, role) VALUES ('$username', '$hashedPassword', '$role')";
        $insertResult = mysqli_query($connection, $insertQuery);

        if ($insertResult) {
            $_SESSION['registration_success'] = true;
            header('Location: index.php'); // Redirect to the login page after successful registration
        } else {
            $errorMsg = "Registration failed. Please try again.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>Register &mdash; Hotel Dafam Semarang</title>

  <!-- General CSS Files -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">

  <!-- CSS Libraries -->
  <link rel="stylesheet" href="assets/modules/bootstrap-social/bootstrap-social.css">

  <!-- Template CSS -->
  <link rel="stylesheet" href="assets/css/style.css">
  <link rel="stylesheet" href="assets/css/components.css">
</head>

<body>
    <div id="app">
        <section class="section">
            <div class="container mt-5">
            <div class="row">
          <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-4 offset-xl-4">
            <div class="login-brand">
            <img src="/assets/image/Logo.png" alt="logo" width="150">
            </div>

            <div class="card card-primary">
              <div class="card-header">
                <h4>Add User</h4>
              </div>

              <div class="card-body">
                <form method="POST" action="" class="needs-validation" novalidate="">
                  <div class="form-group">
                    <label for="username">Username</label>
                    <input id="username" type="text" class="form-control" name="username" tabindex="1" required autofocus>
                    <div class="invalid-feedback">
                      Mohon isi username
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="d-block">
                      <label for="password" class="control-label">Password</label>
                    </div>
                    <input id="password" type="password" class="form-control" name="password" tabindex="2" required>
                    <div class="invalid-feedback">
                      Mohon isi kata sandi
                    </div>
                  </div>

                <div class="form-group">
                    <label for="role">Role</label>
                    <select id="role" class="form-control" name="role" tabindex="3" required>
                        <option value="user">user</option>
                        <option value="admin">admin</option>
                    </select>
                <div class="invalid-feedback">
                Please select a role.
            </div>
        </div>

                  <div class="form-group">
                    <button name="submit" type="submit" class="btn btn-primary btn-lg btn-block" tabindex="4">
                      Register
                    </button>
                  </div>
                  <div class="form-group">
                  <a href="./index.php" class="btn btn-secondary btn-lg btn-block" tabindex="5">Batal</a>
                  </div>
                    <!-- Display the error message if it exists -->
                    <?php if (!empty($errorMsg)): ?>
                        <p style="color: red;"><?php echo $errorMsg; ?></p>
                    <?php endif; ?>
                </form>
            </div>
        </section>
    </div>

    <div class="simple-footer">
              Copyright &copy; 2024 Agus Budiono Prastyo
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

  <!-- General JS Scripts -->
  <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.nicescroll/3.7.6/jquery.nicescroll.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js"></script>
  <script src="assets/js/stisla.js"></script>

  <!-- JS Libraies -->

  <!-- Template JS File -->
  <script src="assets/js/scripts.js"></script>
  <script src="assets/js/custom.js"></script>

  <!-- Page Specific JS File -->
</body>

</html>